/*
 * Decompiled with CFR 0.152.
 */
package weka.experiment;

import weka.core.RevisionUtils;
import weka.core.Utils;
import weka.experiment.ResultMatrix;

public class ResultMatrixPlainText
extends ResultMatrix {
    private static final long serialVersionUID = 1502934525382357937L;

    public ResultMatrixPlainText() {
        this(1, 1);
    }

    public ResultMatrixPlainText(int cols, int rows) {
        super(cols, rows);
    }

    public ResultMatrixPlainText(ResultMatrix matrix) {
        super(matrix);
    }

    @Override
    public String globalInfo() {
        return "Generates the output as plain text (for fixed width fonts).";
    }

    @Override
    public String getDisplayName() {
        return "Plain Text";
    }

    @Override
    public int getDefaultRowNameWidth() {
        return 25;
    }

    @Override
    public int getDefaultCountWidth() {
        return 5;
    }

    @Override
    public String toStringHeader() {
        String result = "";
        String[][] data = new String[this.m_HeaderKeys.size()][2];
        int i = 0;
        while (i < this.m_HeaderKeys.size()) {
            data[i][0] = String.valueOf(this.m_HeaderKeys.get(i).toString()) + ":";
            data[i][1] = this.m_HeaderValues.get(i).toString();
            ++i;
        }
        int size = this.getColSize(data, 0);
        i = 0;
        while (i < data.length) {
            data[i][0] = this.padString(data[i][0], size);
            ++i;
        }
        i = 0;
        while (i < data.length) {
            result = String.valueOf(result) + data[i][0] + " " + data[i][1] + "\n";
            ++i;
        }
        return result;
    }

    @Override
    public String toStringMatrix() {
        String line;
        int i;
        StringBuffer result = new StringBuffer();
        StringBuffer head = new StringBuffer();
        StringBuffer body = new StringBuffer();
        StringBuffer foot = new StringBuffer();
        String[][] cells = this.toArray();
        int[] startMeans = new int[this.getColCount()];
        int[] startSigs = new int[this.getColCount() - 1];
        int maxLength = 0;
        int n = 1;
        while (n < cells[0].length) {
            int size = this.getColSize(cells, n, true, true);
            i = 1;
            while (i < cells.length - 1) {
                cells[i][n] = this.padString(cells[i][n], size, true);
                ++i;
            }
            ++n;
        }
        int indexBase = 1;
        if (this.getShowStdDev()) {
            ++indexBase;
        }
        int indexSecond = indexBase + 1;
        if (this.getShowStdDev()) {
            ++indexSecond;
        }
        int j = 0;
        int k = 0;
        i = 1;
        while (i < cells.length - 1) {
            if (this.isAverage(i)) {
                body.append(String.valueOf(this.padString("", maxLength).replaceAll(".", "-")) + "\n");
            }
            line = "";
            n = 0;
            while (n < cells[0].length) {
                if (i == 1) {
                    if (this.isMean(n)) {
                        startMeans[j] = line.length();
                        ++j;
                    }
                    if (this.isSignificance(n)) {
                        startSigs[k] = line.length();
                        ++k;
                    }
                }
                if (n == 0) {
                    line = String.valueOf(line) + this.padString(cells[i][n], this.getRowNameWidth());
                    line = !this.isAverage(i) ? String.valueOf(line) + this.padString("(" + Utils.doubleToString(this.getCount(this.getDisplayRow(i - 1)), 0) + ")", this.getCountWidth(), true) : String.valueOf(line) + this.padString("", this.getCountWidth(), true);
                } else {
                    if (this.isMean(n)) {
                        line = String.valueOf(line) + "  ";
                    }
                    line = this.getShowStdDev() ? (this.isMean(n - 1) ? (!cells[i][n].trim().equals("") ? String.valueOf(line) + "(" + cells[i][n] + ")" : String.valueOf(line) + " " + cells[i][n] + " ") : String.valueOf(line) + " " + cells[i][n]) : String.valueOf(line) + " " + cells[i][n];
                }
                if (n == indexBase) {
                    line = String.valueOf(line) + " |";
                }
                ++n;
            }
            if (i == 1) {
                maxLength = line.length();
            }
            body.append(String.valueOf(line) + "\n");
            ++i;
        }
        line = this.padString(cells[0][0], startMeans[0]);
        i = -1;
        n = 1;
        while (n < cells[0].length) {
            if (this.isMean(n)) {
                if (++i == 0) {
                    line = this.padString(line, startMeans[i] - this.getCountWidth());
                } else if (i == 1) {
                    line = this.padString(line, startMeans[i] - " |".length());
                } else if (i > 1) {
                    line = this.padString(line, startMeans[i]);
                }
                if (i == 1) {
                    line = String.valueOf(line) + " |";
                }
                line = String.valueOf(line) + " " + cells[0][n];
            }
            ++n;
        }
        line = this.padString(line, maxLength);
        head.append(String.valueOf(line) + "\n");
        head.append(String.valueOf(line.replaceAll(".", "-")) + "\n");
        body.append(String.valueOf(line.replaceAll(".", "-")) + "\n");
        if (this.getColCount() > 1) {
            line = String.valueOf(this.padString(cells[cells.length - 1][0], startMeans[1] - 2, true)) + " |";
            i = 0;
            n = 1;
            while (n < cells[cells.length - 1].length) {
                if (this.isSignificance(n)) {
                    line = this.padString(line, startSigs[i] + 1 - cells[cells.length - 1][n].length());
                    line = String.valueOf(line) + " " + cells[cells.length - 1][n];
                    ++i;
                }
                ++n;
            }
            line = this.padString(line, maxLength);
        } else {
            line = String.valueOf(this.padString(cells[cells.length - 1][0], line.length() - 2)) + " |";
        }
        foot.append(String.valueOf(line) + "\n");
        result.append(head.toString());
        result.append(body.toString());
        result.append(foot.toString());
        return result.toString();
    }

    @Override
    public String toStringKey() {
        String result = "Key:\n";
        int i = 0;
        while (i < this.getColCount()) {
            if (!this.getColHidden(i)) {
                result = String.valueOf(result) + this.LEFT_PARENTHESES + (i + 1) + this.RIGHT_PARENTHESES + " " + this.removeFilterName(this.m_ColNames[i]) + "\n";
            }
            ++i;
        }
        return result;
    }

    @Override
    public String toStringSummary() {
        if (this.m_NonSigWins == null) {
            return "-summary data not set-";
        }
        String result = "";
        String titles = "";
        int resultsetLength = 1 + Math.max((int)(Math.log(this.getColCount()) / Math.log(10.0)), (int)(Math.log(this.getRowCount()) / Math.log(10.0)));
        int i = 0;
        while (i < this.getColCount()) {
            if (!this.getColHidden(i)) {
                titles = String.valueOf(titles) + " " + Utils.padLeft(this.getSummaryTitle(i), resultsetLength * 2 + 3);
            }
            ++i;
        }
        result = String.valueOf(result) + titles + "  (No. of datasets where [col] >> [row])\n";
        i = 0;
        while (i < this.getColCount()) {
            if (!this.getColHidden(i)) {
                int j = 0;
                while (j < this.getColCount()) {
                    if (!this.getColHidden(j)) {
                        result = String.valueOf(result) + " ";
                        result = j == i ? String.valueOf(result) + Utils.padLeft("-", resultsetLength * 2 + 3) : String.valueOf(result) + Utils.padLeft(this.m_NonSigWins[i][j] + " (" + this.m_Wins[i][j] + ")", resultsetLength * 2 + 3);
                    }
                    ++j;
                }
                result = String.valueOf(result) + " | " + this.getSummaryTitle(i) + " = " + this.getColName(i) + '\n';
            }
            ++i;
        }
        return result;
    }

    @Override
    public String toStringRanking() {
        if (this.m_RankingWins == null) {
            return "-ranking data not set-";
        }
        int biggest = Math.max(this.m_RankingWins[Utils.maxIndex(this.m_RankingWins)], this.m_RankingLosses[Utils.maxIndex(this.m_RankingLosses)]);
        int width = Math.max(2 + (int)(Math.log(biggest) / Math.log(10.0)), ">-<".length());
        String result = String.valueOf(Utils.padLeft(">-<", width)) + ' ' + Utils.padLeft(">", width) + ' ' + Utils.padLeft("<", width) + " Resultset\n";
        int[] ranking = Utils.sort(this.m_RankingDiff);
        int i = this.getColCount() - 1;
        while (i >= 0) {
            int curr = ranking[i];
            if (!this.getColHidden(curr)) {
                result = String.valueOf(result) + Utils.padLeft("" + this.m_RankingDiff[curr], width) + ' ' + Utils.padLeft("" + this.m_RankingWins[curr], width) + ' ' + Utils.padLeft("" + this.m_RankingLosses[curr], width) + ' ' + this.removeFilterName(this.m_ColNames[curr]) + '\n';
            }
            --i;
        }
        return result;
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 8034 $");
    }

    public static void main(String[] args) {
        ResultMatrixPlainText matrix = new ResultMatrixPlainText(3, 3);
        matrix.addHeader("header1", "value1");
        matrix.addHeader("header2", "value2");
        matrix.addHeader("header2", "value3");
        int i = 0;
        while (i < matrix.getRowCount()) {
            int n = 0;
            while (n < matrix.getColCount()) {
                matrix.setMean(n, i, (i + 1) * n);
                matrix.setStdDev(n, i, (double)(i + 1) * (double)n / 100.0);
                if (i == n) {
                    if (i % 2 == 1) {
                        matrix.setSignificance(n, i, 1);
                    } else {
                        matrix.setSignificance(n, i, 2);
                    }
                }
                ++n;
            }
            ++i;
        }
        System.out.println("\n\n--> " + ((ResultMatrix)matrix).getDisplayName());
        System.out.println("\n1. complete\n");
        System.out.println(String.valueOf(((ResultMatrix)matrix).toStringHeader()) + "\n");
        System.out.println(String.valueOf(((ResultMatrix)matrix).toStringMatrix()) + "\n");
        System.out.println(((ResultMatrix)matrix).toStringKey());
        System.out.println("\n2. complete with std deviations\n");
        matrix.setShowStdDev(true);
        System.out.println(((ResultMatrix)matrix).toStringMatrix());
        System.out.println("\n3. cols numbered\n");
        matrix.setPrintColNames(false);
        System.out.println(((ResultMatrix)matrix).toStringMatrix());
        System.out.println("\n4. second col missing\n");
        matrix.setColHidden(1, true);
        System.out.println(((ResultMatrix)matrix).toStringMatrix());
        System.out.println("\n5. last row missing, rows numbered too\n");
        matrix.setRowHidden(2, true);
        matrix.setPrintRowNames(false);
        System.out.println(((ResultMatrix)matrix).toStringMatrix());
        System.out.println("\n6. mean prec to 3\n");
        matrix.setMeanPrec(3);
        matrix.setPrintRowNames(false);
        System.out.println(((ResultMatrix)matrix).toStringMatrix());
    }
}

